# Replication Package: Deposit Franchise Runs.

## Overview
This replication package accompanies the paper "Deposit Franchise Runs", providing all code and data necessary to reproduce the results presented in the manuscript.

## Instructions for Replication

### Requirements
- Stata 17 or later
- Required packages: see MASTER.do, packages will be installed automatically if missing.
 
### Execution
1. Set the working directory in `MASTER.do` to point to the replication package folder
2. Run `MASTER.do` to execute the complete replication
3. Results will be saved in the `output/` folder
4. Compile the LaTeX file `output/figures_and_tables.tex` to produce a PDF containing all tables and figures

## General Workflow

The replication process consists of four main stages:

- **Stage 1**: Data preparation from raw Call Reports to estimation-ready dataset using `01_data_preparation/` scripts.
- **Stage 2**: Estimation of bank values including deposit betas, costs, mark-to-market losses, and bank valuations using `02_estimation/` scripts.
- **Stage 3**: Analysis and output generation (tables and figures) using `03_analysis/` scripts.

More details on the structure of each section can be found in the respective master file of each section.

## Directory Structure
```
replication_pkg/
├── README.md                    # This file
├── MASTER.do                    # Main execution file
├── code/                        # All Stata scripts
│   ├── 01_data_preparation/    # STARTS HERE for most users
│   │   ├── master_data_prep.do # Master file for data preparation
│   │   ├── 1a_deposit_construction.do # Deposit volume & interest variables
│   │   ├── 1b_final_cleaning.do # Final panel data cleaning
│   │   └── 1c_sample_restrictions.do # Sample restrictions & outlier removal
│   ├── 02_estimation/ # Estimation
│   │   ├── master_estimation.do # Master file for estimation
│   │   ├── 2a_deposit_betas.do    # Estimate deposit betas
│   │   ├── 2b_deposit_costs.do  # Estimate deposit costs
│   │   ├── 2c_mtm_assets.do     # Calculate mark-to-market asset losses
│   │   ├── 2d_deposit_franchises.do # Compute deposit franchise values
│   │   └── 2e_bank_values.do # Calculate bank value measures
│   ├── 03_analysis/             # Analysis, tables, and figures
├── data/                        # Data files
│   ├── raw/                     # Raw input data 
│   │   ├── call_reports.dta # pre-processed call report data (see bellow)
│   │   ├── indices_price_oad.dta # Bloomberg indices data (see bellow)
│   │   ├── fedfunds_avg.dta # Fed funds rate data (see bellow)
│   │   └── tenyearrate.data # Long term rate data (see bellow)
│   ├── clean/                   # Processed datasets
│   └── temp/                    # Temporary files
└── output/                      # Generated results
    ├── figures_and_tables.tex   # A latex document containing all figures and tables generated.
    ├── tables/                  # Regression tables
    └── figures/                 # Plots and graphs
```

## Data Description

### Included Datasets
The following datasets are included in the `data/raw/` folder:

#### 1. call_reports.dta
This dataset is a pre-processed version of Call Reports data (2015Q1 to 2023Q4) obtained from WRDS for the full universe of banks. Variables have been lightly processed to get readable & time-consistent time series, following the methodology highlighted in Drechsler, Savov & Schnabl (2017) The Deposits Channel of Monetary Policy, The Quarterly Journal of Economics. (See https://pages.stern.nyu.edu/~pschnabl/data/data_callreport.htm for details on processing the time series)

#### 2. fedfunds_avg.dta and tenyearrate.dta
A dataset containing treasury rates data for the period 2015-2024, organized by quarter. It was obtained from FRED and includes:
- Effective Federal Fund Rates (variable DFF in FRED API, aggregate in Quarterly Average and presented as decimal). The variable created is ffr.
- 10-Year Treasury Constant Maturity Rates (variable DGS10 in FRED API). For each quarter between 2020q1 and 2024q4 we select an appropriate date for end of quarter and associate it to the corresponding quarter. Variable created are dgs10 (10-Year rate) and f1_dgs10 (next quarter 10 year rate).
Data was obtained from the FRED API on July 03 2025.

#### 3. indices_price_data.dta
This dataset contains time series data for Bloomberg US Treasury and Mortgage-Backed Securities (MBS) indices. It includes price and option-adjusted duration (OAD) measures for various maturity segments. The data is structured with the following variables:
- `date`: The observation date
- `p_tre_*`: Treasury index prices for different maturity segments (e.g., `p_tre_0y_1y` for 0-1 year, `p_tre_10y_20y` for 10-20 years)
- `oad_tre_*`: Option-adjusted duration for Treasury indices corresponding to the maturity segments
- `p_mbs_*`: MBS index prices for different maturity segments (e.g., `p_mbs_1y_5y` for 1-5 years, `p_mbs_30y` for 30 years)
- `oad_mbs_*`: Option-adjusted duration for MBS indices corresponding to the maturity segments

The dataset spans the period from December 2020 to February 2024, with observations aggregated to the end of each quarter. The indices are normalized and processed to facilitate the calculation of price changes over time. For more details on the origin and processing of this dataset, please refer to Appendix A in the manuscript. 

### Last Updated
Aug 9, 2025

